package edu.govschool.midterm.problem2;

/**
 * Representation of the binary search tree data structure.
 * @author Mr. Davis
 */
public class Tree 
{
    private Node root;
    
    /**
     * Empty constructor.
     * Creates a <code>Tree</code> with an empty root
     */
    public Tree()
    {
        this(null);
    }
    
    /**
     * Default constructor.
     * Creates a <code>Tree</code> with the specified 
     * <code>Node</code> as the root
     */
    public Tree(Node root)
    {
        this.root = root;
    }
    
    /**
     * Returns the root of the <code>Tree</code>.
     * @return the root
     */
    public Node getRoot()
    {
        return this.root;
    }
    
    /**
     * Tests if the <code>Tree</code> is empty.
     * @return <code>true</code> if the root is <code>null</code>
     */
    public boolean isEmpty()
    {
        return root == null;
    }
    
    /**
     * Inserts some data into the <code>Tree</code>.
     * We traverse down the <code>Tree</code> recursively following the rules of
     * a BST.
     * @param data the data to insert
     */
    public void insert(int data)
    {
        insert(data, this.getRoot());
    }
    
    /**
     * Inserts some data into the <code>Tree</code> recursively.
     * This method actually inserts the data. This is a common OOP practice when
     * a method needs multiple arguments to work, but can be called in practice 
     * with just one (as in this case)
     * @param data the data to insert
     * @param node the current <code>Node</code>
     */
    private void insert(int data, Node node)
    {
        if (node == null)
            root = new Node(data);
        else {
            if (data < node.getData()) {
                if (node.getLeft() == null) {
                    node.setLeft(new Node(data));
                } else {
                    insert(data, node.getLeft());
                }
            } else {
                if (node.getRight() == null) {
                    node.setRight(new Node(data));
                } else {
                    insert(data, node.getRight());
                }
            }
        }
    }

    /**
     * Prints the <code>Tree</code>.
     * First, the right sub-tree of the current <code>Node</code> is output, 
     * then the <code>Node</code> itself, then the left sub-tree, recursively!
     */
    public void print()
    {
        outputTree(this.getRoot(), 0);
    }

    /**
     * Output a <code>Tree</code> rooted at a given <code>Node</code>.
     */
    private void outputTree(Node curr, int spaces)
    {
        if (curr == null) {
            return;
        } else {
            outputTree(curr.getRight(), spaces + 5);
            for (int i = 0; i < spaces; i++) {
                System.out.print(" ");
            }
            System.out.print(curr.getData() + "\n");
            outputTree(curr.getLeft(), spaces + 5);
        }
    }
    
    // Your code here
}