package edu.govschool.midterm.problem2;

/**
 * Representation of a <code>Node</code> for a binary search 
 * <code>Tree</code>.
 * @author Mr. Davis
 */
public class Node 
{
    private int data;
    private Node left;
    private Node right;
    
    /**
     * Empty constructor.
     * Creates an empty <code>Node</code> with no children.
     */
    public Node()
    {
        this(0, null, null);
    }
    
    /**
     * Convenience constructor.
     * Creates a <code>Node</code> with the given data and no children.
     * @param data the data to store in the <code>Node</code>
     */
    public Node(int data)
    {
        this(data, null, null);
    }
    
    /**
     * Default constructor.
     * Creates a <code>Node</code> with the given data and children.
     * @param data the data to store in the <code>Node</code>
     * @param left the left child <code>Node</code>
     * @param right the right child <code>Node</code>
     */
    public Node(int data, Node left, Node right)
    {
        this.data  = data;
        this.left  = left;
        this.right = right;
    }
    
    /**
     * Get the data stored in the <code>Node</code>.
     * @return the stored data
     */
    public int getData()
    {
        return this.data;
    }
    
    /**
     * Get the left child of the <code>Node</code>.
     * @return the left child
     */
    public Node getLeft()
    {
        return this.left;
    }
    
    /**
     * Get the right child of the <code>Node</code>.
     * @return the right child
     */
    public Node getRight()
    {
        return this.right;
    }
    
    /**
     * Set the left child of the <code>Node</code>.
     * @param left the new left child
     */
    public void setLeft(Node left)
    {
        this.left = left;
    }
    
    /**
     * Set the right child of the <code>Node</code>.
     * @param right the new right child
     */
    public void setRight(Node right)
    {
        this.right = right;
    }
    
    /**
     * Create a <code>String</code> representation of the <code>Node</code>.
     * @return the <code>Node</code> as a <code>String</code>
     */
    @Override
    public String toString()
    {
        return this.data + "";
    }
}