package edu.govschool.midterm.problem1;

/**
 * Representation of the set data structure.
 * @author Mr. Davis
 */
public class Set extends LinkedList
{
    /**
     * Empty constructor.
     * Creates the empty <code>Set</code>.
     */
    public Set()
    {
        super(null);
    }
    
    /**
     * Default constructor.
     * Creates a <code>Set</code> with the given <code>Node</code> as the head.
     * @param node the first element in the <code>Set</code>
     */
    public Set(Node node)
    {
        super(node);
    }
    
    /**
     * Adds a <code>Node</code> to the <code>Set</code>.
     * @param node the node to add
     */
    @Override
    public void append(Node node)
    {
        if (!this.contains(node)) {
            if (this.head == null) {
                this.head = node;
                this.tail = this.head;
            } else {
                Node tmp = this.tail;
                this.tail = node;
                tmp.setNext(this.tail);
            }
        }
    }
    
    /**
     * Adds an element to the <code>Set</code>.
     * @param data the element to add
     */
    @Override
    public void append(int data)
    {
        if (!this.contains(data)) {
            Node node = new Node(data);
            this.append(node);
        }
    }
    
    /**
     * Creates a <code>String</code> representation of the <code>Set</code>.
     * @return the <code>Set</code> as a <code>String</code>
     */
    @Override
    public String toString()
    {
        if (this.isEmpty()) return "Empty Set";
        else {
            StringBuilder sb = new StringBuilder("{");
            Node tmp = this.head;
            
            while (tmp != null) {
                sb.append(tmp);
                
                tmp = tmp.getNext();
                if (tmp != null) {
                    sb.append(", ");
                }
            }            
            return sb.toString() + "}";
        }
    }
    
    // Your code here
}