package edu.govschool.midterm.problem1;

/**
 * Representation of a <code>Node</code> for a linked list.
 * @author Mr. Davis
 */
public class Node 
{
    private int data;
    private Node next;
    
    /**
     * Empty constructor.
     * Creates an empty <code>Node</code> with no <code>Node</code> after.
     */
    public Node()
    {
        this(0, null);
    }
    
    /**
     * Convenience constructor.
     * Creates a <code>Node</code> with the given data and no following 
     * <code>Node</code>.
     * @param data the data to store in the <code>Node</code>
     */
    public Node(int data)
    {
        this(data, null);
    }
    
    /**
     * Convenience constructor.
     * Creates an empty <code>Node</code> with the given <code>Node</code> 
     * following.
     * @param next the <code>Node</code> after
     */
    public Node(Node next)
    {
        this(0, next);
    }
    
    /**
     * Default constructor.
     * Creates a <code>Node</code> with the given data and following 
     * <code>Node</code>.
     * @param data the data to store in the <code>Node</code>
     * @param next the <code>Node</code> after
     */
    public Node(int data, Node next)
    {
        this.data = data;
        this.next = next;
    }
    
    /**
     * Get the data stored in the <code>Node</code>.
     * @return the stored data
     */
    public int getData()
    {
        return this.data;
    }
    
    /**
     * Get the following <code>Node</code>.
     * @return the following <code>Node</code>
     */
    public Node getNext()
    {
        return this.next;
    }
    
    /**
     * Set the following <code>Node</code>.
     * @param next the new <code>Node</code> to follow
     */
    public void setNext(Node next)
    {
        this.next = next;
    }
    
    /**
     * Create a <code>String</code> representation of the <code>Node</code>.
     * @return the <code>Node</code> as a <code>String</code>
     */
    @Override
    public String toString()
    {
        return this.data + "";
    }
}