package edu.govschool.midterm.problem1;

/**
 * Representation of the linked list data structure.
 * @author Mr. Davis
 */
public class LinkedList 
{
    /**
     * The first <code>Node</code> in the <code>LinkedList</code>.
     */
    protected Node head;
    /**
     * The last <code>Node</code> in the <code>LinkedList</code>.
     */
    protected Node tail;
    
    /**
     * Empty constructor.
     * Creates an empty <code>LinkedList</code>.
     */
    public LinkedList()
    {
        this(null);
    }
    
    /**
     * Default constructor.
     * Creates a <code>LinkedList</code> with the given <code>Node</code> as the
     * head.
     * @param node the first <code>Node</code> in the <code>LinkedList</code>
     */
    public LinkedList(Node node)
    {
        this.head = node;
        this.tail = this.head;
    }
    
    /**
     * Set the head of the <code>LinkedList</code>.
     * @param node the new head
     */
    public void setHead(Node node)
    {
        this.head = node;
    }
    
    /**
     * Set the tail of the <code>LinkedList</code>.
     * @param node the new tail
     */
    public void setTail(Node node)
    {
        this.tail = node;
    }
    
    /**
     * Get the head of the <code>LinkedList</code>.
     * @return the current head
     */
    public Node getHead()
    {
        return this.head;
    }
    
    /**
     * Get the tail of the <code>LinkedList</code>.
     * @return the current tail
     */
    public Node getTail()
    {
        return this.tail;
    }
    
    /**
     * Test if the <code>LinkedList</code> is empty.
     * @return <code>true</code> if the <code>LinkedList</code> is empty, 
     * <code>false</code> otherwise
     */
    public boolean isEmpty()
    {
        return this.head == null;
    }
    
    /**
     * Add a <code>Node</code> to the <code>LinkedList</code>.
     * @param node the <code>Node</code> to add
     */
    public void append(Node node)
    {
        if (this.head == null) {
            this.head = node;
            this.tail = this.head;
        } else {
            Node tmp = this.tail;
            this.tail = node;
            tmp.setNext(this.tail);
        }
    }
    
    /**
     * Add a value to the <code>LinkedList</code>.
     * @param data the value to add
     */
    public void append(int data)
    {
        Node node = new Node(data);
        this.append(node);
    }
    
    /**
     * Removes a <code>Node</code> from the end of the <code>LinkedList</code>.
     */
    public void remove()
    {
        if (!this.isEmpty()) {
            if (this.head == this.tail) {
                this.head = null;
                this.tail = this.head;
            } else {
                Node prev = this.head;
                Node curr = this.head;
                while (curr != this.tail) {
                    prev = curr;
                    curr = curr.getNext();
                }
                prev.setNext(null);
                this.tail = prev;
            }
        }
    }
    
    /**
     * Tests if a value is contained in the <code>LinkedList</code>.
     * @param data the value to find
     * @return <code>true</code> if the value is found, <code>false</code> 
     * otherwise
     */
    public boolean contains(int data)
    {
        if (!this.isEmpty()) {
            Node tmp = head;
            
            while (tmp != null) {
                if (tmp.getData() == data) {
                    return true;
                }
                tmp = tmp.getNext();
            }
        }
        return false;
    }
    
    /**
     * Tests if a <code>Node</code> is contained in the <code>LinkedList</code>.
     * This checks for the data within the <code>Node</code>, not the reference
     * itself.
     * @param node the <code>Node</code> to find
     * @return <code>true</code> if the <code>Node</code> is found, 
     * <code>false</code> otherwise
     */
    public boolean contains(Node node)
    {
        int data = node.getData();
        return contains(data);
    }
    
    /**
     * Create a <code>String</code> representation of the 
     * <code>LinkedList</code>.
     * @return the <code>LinkedList</code> as a <code>String</code>
     */
    @Override
    public String toString()
    {
        if (this.isEmpty()) {
            return "Empty List";
        } else {
            StringBuilder sb = new StringBuilder();
            Node tmp = head;
            while (tmp != null) {
                sb.append(tmp);
                tmp = tmp.getNext();
                
                if (tmp != null) {
                    sb.append(" --> ");
                }
            }
            return sb.toString();
        }
    }
}